#ifndef MT9D111_REGS_H
#define MT9D111_REGS_H
#include "ArduCAM.h"
//#include <avr/pgmspace.h>

/*******************************************************************************************
 #  Display resolution standards #
        QCIF    : 176 x 144
        CIF     : 352 x 288
        QVGA    : 320 x 240
        VGA     : 640 x 480 
        SVGA    : 800 x 600 
        XGA     : 1024 x 768 
        WXGA    : 1280 x 800 
        QVGA    : 1280 x 960 
        SXGA    : 1280 x 1024 
        SXGA+   : 1400 x 1050 
        WSXGA+  : 1680 x 1050 
        UXGA    : 1600 x 1200 
        WUXGA   : 1920 x 1200 
        QXGA    : 2048 x 1536
********************************************************************************************/

const struct sensor_reg MT9D111_QVGA_30fps[] PROGMEM=
{

	{0xf0, 0x0},		
    {0x33, 0x0343        }, // RESERVED_CORE_33
	{0xf0, 0x1},
    {0xC6, 0xA115        }, //SEQ_LLMODE
    {0xC8, 0x0020        }, //SEQ_LLMODE
	{0xf0, 0x0},
    {0x38, 0x0866        }, // RESERVED_CORE_38

    //{MT9D111_DELAY, 0x00, 0x0064 }, // Delay =100ms

	{0xf0, 0x2},
    {0x80, 0x0168        }, // LENS_CORRECTION_CONTROL
    {0x81, 0x6432        }, // ZONE_BOUNDS_X1_X2
    {0x82, 0x3296        }, // ZONE_BOUNDS_X0_X3
    {0x83, 0x9664        }, // ZONE_BOUNDS_X4_X5
    {0x84, 0x5028        }, // ZONE_BOUNDS_Y1_Y2
    {0x85, 0x2878        }, // ZONE_BOUNDS_Y0_Y3
    {0x86, 0x7850        }, // ZONE_BOUNDS_Y4_Y5
    {0x87, 0x0000        }, // CENTER_OFFSET
    {0x88, 0x0152        }, // FX_RED
    {0x89, 0x015C        }, // FX_GREEN
    {0x8A, 0x00F4        }, // FX_BLUE
    {0x8B, 0x0108        }, // FY_RED
    {0x8C, 0x00FA        }, // FY_GREEN
    {0x8D, 0x00CF        }, // FY_BLUE
    {0x8E, 0x09AD        }, // DF_DX_RED
    {0x8F, 0x091E        }, // DF_DX_GREEN
    {0x90, 0x0B3F        }, // DF_DX_BLUE
    {0x91, 0x0C85        }, // DF_DY_RED
    {0x92, 0x0CFF        }, // DF_DY_GREEN
    {0x93, 0x0D86        }, // DF_DY_BLUE
    {0x94, 0x163A        }, // SECOND_DERIV_ZONE_0_RED
    {0x95, 0x0E47        }, // SECOND_DERIV_ZONE_0_GREEN
    {0x96, 0x103C        }, // SECOND_DERIV_ZONE_0_BLUE
    {0x97, 0x1D35        }, // SECOND_DERIV_ZONE_1_RED
    {0x98, 0x173E        }, // SECOND_DERIV_ZONE_1_GREEN
    {0x99, 0x1119        }, // SECOND_DERIV_ZONE_1_BLUE
    {0x9A, 0x1663        }, // SECOND_DERIV_ZONE_2_RED
    {0x9B, 0x1569        }, // SECOND_DERIV_ZONE_2_GREEN
    {0x9C, 0x104C        }, // SECOND_DERIV_ZONE_2_BLUE
    {0x9D, 0x1015        }, // SECOND_DERIV_ZONE_3_RED
    {0x9E, 0x1010        }, // SECOND_DERIV_ZONE_3_GREEN
    {0x9F, 0x0B0A        }, // SECOND_DERIV_ZONE_3_BLUE
    {0xA0, 0x0D53        }, // SECOND_DERIV_ZONE_4_RED
    {0xA1, 0x0D51        }, // SECOND_DERIV_ZONE_4_GREEN
    {0xA2, 0x0A44        }, // SECOND_DERIV_ZONE_4_BLUE
    {0xA3, 0x1545        }, // SECOND_DERIV_ZONE_5_RED
    {0xA4, 0x1643        }, // SECOND_DERIV_ZONE_5_GREEN
    {0xA5, 0x1231        }, // SECOND_DERIV_ZONE_5_BLUE
    {0xA6, 0x0047        }, // SECOND_DERIV_ZONE_6_RED
    {0xA7, 0x035C        }, // SECOND_DERIV_ZONE_6_GREEN
    {0xA8, 0xFE30        }, // SECOND_DERIV_ZONE_6_BLUE
    {0xA9, 0x4625        }, // SECOND_DERIV_ZONE_7_RED
    {0xAA, 0x47F3        }, // SECOND_DERIV_ZONE_7_GREEN
    {0xAB, 0x5859        }, // SECOND_DERIV_ZONE_7_BLUE
    {0xAC, 0x0000        }, // X2_FACTORS
    {0xAD, 0x0000        }, // GLOBAL_OFFSET_FXY_FUNCTION
    {0xAE, 0x0000        }, // K_FACTOR_IN_K_FX_FY
    
    {0xf0, 0x1},
    {0x08, 0x01FC        }, // COLOR_PIPELINE_CONTROL
    //{MT9D111_DELAY, 0x00, 0x0064 }, // Delay =100ms
	{0xf0, 0x1},
    {0xBE, 0x0004        }, // YUV_YCBCR_CONTROL
	{0xf0, 0x0},
    {0x65, 0xA000        }, // CLOCK_ENABLING
    //{MT9D111_DELAY, 0x00, 0x0064 }, // Delay =100ms
	
	{0xf0, 0x1},
    {0xC6, 0xA102        }, //SEQ_MODE
    {0xC8, 0x001F        }, //SEQ_MODE
    {0x08, 0x01FC        }, // COLOR_PIPELINE_CONTROL
    {0x08, 0x01EC        }, // COLOR_PIPELINE_CONTROL
    {0x08, 0x01FC        }, // COLOR_PIPELINE_CONTROL
    {0x36, 0x0F08        }, // APERTURE_PARAMETERS
    {0xC6, 0x270B        }, //MODE_CONFIG
    {0xC8, 0x0030        }, //MODE_CONFIG, JPEG disabled for A and B
    {0xC6, 0xA121        }, //SEQ_CAP_MODE
    {0xC8, 0x007f        }, //SEQ_CAP_MODE (127 frames before switching to Preview)

	{0xf0, 0x0},
    {0x05, 0x011E        }, // HORZ_BLANK_B
    {0x06, 0x006F        }, // VERT_BLANK_B
    {0x07, 0xFE          }, // HORZ_BLANK_A
    {0x08, 19            }, // VERT_BLANK_A
    {0x20, 0x0302        }, // READ_MODE_B (Image flip settings)
    {0x21, 0x8400        }, // READ_MODE_A (1ADC)

	{0xf0, 0x1},
    {0xC6, 0x2717        }, //MODE_SENSOR_X_DELAY_A
    {0xC8, 792           }, //MODE_SENSOR_X_DELAY_A
    {0xC6, 0x270F        }, //MODE_SENSOR_ROW_START_A
    {0xC8, 0x001C        }, //MODE_SENSOR_ROW_START_A
    {0xC6, 0x2711        }, //MODE_SENSOR_COL_START_A
    {0xC8, 0x003C        }, //MODE_SENSOR_COL_START_A
    {0xC6, 0x2713        }, //MODE_SENSOR_ROW_HEIGHT_A
    {0xC8, 0x04B0        }, //MODE_SENSOR_ROW_HEIGHT_A
    {0xC6, 0x2715        }, //MODE_SENSOR_COL_WIDTH_A
    {0xC8, 0x0640        }, //MODE_SENSOR_COL_WIDTH_A
    {0xC6, 0x2719        }, //MODE_SENSOR_ROW_SPEED_A
    {0xC8, 0x0011        }, //MODE_SENSOR_ROW_SPEED_A
    {0xC6, 0x2707        }, //MODE_OUTPUT_WIDTH_B
    {0xC8, 0x0640        }, //MODE_OUTPUT_WIDTH_B
    {0xC6, 0x2709        }, //MODE_OUTPUT_HEIGHT_B
    {0xC8, 0x04B0        }, //MODE_OUTPUT_HEIGHT_B
    {0xC6, 0x271B        }, //MODE_SENSOR_ROW_START_B
    {0xC8, 0x001C        }, //MODE_SENSOR_ROW_START_B
    {0xC6, 0x271D        }, //MODE_SENSOR_COL_START_B
    {0xC8, 0x003C        }, //MODE_SENSOR_COL_START_B
    {0xC6, 0x271F        }, //MODE_SENSOR_ROW_HEIGHT_B
    {0xC8, 0x04B0        }, //MODE_SENSOR_ROW_HEIGHT_B
    {0xC6, 0x2721        }, //MODE_SENSOR_COL_WIDTH_B
    {0xC8, 0x0640        }, //MODE_SENSOR_COL_WIDTH_B
    {0xC6, 0x2723        }, //MODE_SENSOR_X_DELAY_B
    {0xC8, 0x0716        }, //MODE_SENSOR_X_DELAY_B
    {0xC6, 0x2725        }, //MODE_SENSOR_ROW_SPEED_B
    {0xC8, 0x0011        }, //MODE_SENSOR_ROW_SPEED_B


//  HANI tmp
////////////////////////////////////////////////////////////

    {0xC6, 0x2703    }, //MODE_OUTPUT_WIDTH_A
    {0xC8, 0x0280    }, //MODE_OUTPUT_WIDTH_A
    {0xC6, 0x2705    }, //MODE_OUTPUT_HEIGHT_A
    {0xC8, 0x01E0    }, //MODE_OUTPUT_HEIGHT_A
    {0xC6, 0x2707    }, //MODE_OUTPUT_WIDTH_B
    {0xC8, 0x0280    }, //MODE_OUTPUT_WIDTH_B
    {0xC6, 0x2709    }, //MODE_OUTPUT_HEIGHT_B
    {0xC8, 0x01E0    }, //MODE_OUTPUT_HEIGHT_B
    {0xC6, 0x2779    }, //Spoof Frame Width
    {0xC8, 0x0280    }, //Spoof Frame Width
    {0xC6, 0x277B    }, //Spoof Frame Height
    {0xC8, 0x01E0    }, //Spoof Frame Height
    {0xC6, 0xA103    }, //SEQ_CMD
    {0xC8, 0x0005    }, //SEQ_CMD

////////////////////////////////////////////////////////////

    //Maximum Slew-Rate on IO-Pads (for Mode A)
    {0xC6, 0x276B        }, //MODE_FIFO_CONF0_A
    {0xC8, 0x0027        }, //MODE_FIFO_CONF0_A
    {0xC6, 0x276D        }, //MODE_FIFO_CONF1_A
    {0xC8, 0xE1E1        }, //MODE_FIFO_CONF1_A
    {0xC6, 0xA76F        }, //MODE_FIFO_CONF2_A
    {0xC8, 0x00E1        }, //MODE_FIFO_CONF2_A


    //Maximum Slew-Rate on IO-Pads (for Mode B)
    {0xC6, 0x2772        }, //MODE_FIFO_CONF0_B
    {0xC8, 0x0027        }, //MODE_FIFO_CONF0_B
    {0xC6, 0x2774        }, //MODE_FIFO_CONF1_B
    {0xC8, 0xE1E1        }, //MODE_FIFO_CONF1_B
    {0xC6, 0xA776        }, //MODE_FIFO_CONF2_B
    {0xC8, 0x00E1        }, //MODE_FIFO_CONF2_B

    //Set maximum integration time to get a minimum of 15 fps at 45MHz
    {0xC6, 0xA20E        }, //AE_MAX_INDEX
    {0xC8, 0x0004        }, //AE_MAX_INDEX
    //Set minimum integration time to get a maximum of 15 fps at 45MHz
    {0xC6, 0xA20D        }, //AE_MAX_INDEX
    {0xC8, 0x0004        }, //AE_MAX_INDEX
    // Configue all GPIO for output and set low to save power
    {0xC6, 0x9078        },
    {0xC8, 0x0000        },
    {0xC6, 0x9079        },
    {0xC8, 0x0000        },
    {0xC6, 0x9070        },
    {0xC8, 0x0000        },
    {0xC6, 0x9071        },
    {0xC8, 0x0000        },
    // gamma and contrast
    {0xC6, 0xA743        }, // MODE_GAM_CONT_A
    {0xC8, 0x0003        }, // MODE_GAM_CONT_A
    {0xC6, 0xA744        }, // MODE_GAM_CONT_B
    {0xC8, 0x0003        }, // MODE_GAM_CONT_B
    //{MT9D111_DELAY, 0x00, 0x01F4 }, // Delay =500m


//  Set PLL
//  Mclk = 19MHz , Pclk = 79MHz
	{0xf0, 0x0},
    {0xF2, 0x0000        },  
    {0x65, 0xE000        }, 
    {0x66, 0x1001},         //PLL Control 1 = 4097
	{0x67, 0x503 },        //PLL Control 2 = 1283
	{0x65, 0xA000},        //Clock CNTRL: PLL ON = 40960
    //{MT9D111_DELAY, 0x00, 0x01F4 }, // Delay =500ms
    {0xf0, 0x0},
    {0x65, 0x2000        },      // CLOCK_ENABLING
    {0xf0, 0x0},
    //{MT9D111_DELAY, 0x00, 0x01F4 }, // Delay =500ms
  
	{0xf0, 0x1},
	{0xC6, 0x2703    }, //MODE_OUTPUT_WIDTH_A
    {0xC8, 0x0140    }, //MODE_OUTPUT_WIDTH_A
    {0xC6, 0x2705    }, //MODE_OUTPUT_HEIGHT_A
    {0xC8, 0x00F0    }, //MODE_OUTPUT_HEIGHT_A
    {0xC6, 0x2707    }, //MODE_OUTPUT_WIDTH_B
    {0xC8, 0x0280    }, //MODE_OUTPUT_WIDTH_B
    {0xC6, 0x2709    }, //MODE_OUTPUT_HEIGHT_B
    {0xC8, 0x01E0    }, //MODE_OUTPUT_HEIGHT_B
    {0xC6, 0x2779    }, //Spoof Frame Width
    {0xC8, 0x0140    }, //Spoof Frame Width
    {0xC6, 0x277B    }, //Spoof Frame Height
    {0xC8, 0x00F0    }, //Spoof Frame Height
    {0xC6, 0xA103    }, //SEQ_CMD
    {0xC8, 0x0005    }, //SEQ_CMD
    
    
    {0xff, 0xffff }
};


	
const struct sensor_reg MT9D111_QVGA_15fps[] PROGMEM=
{
	{0xf0, 0x0}, 
	{0x5, 0x11e}, 
	{0x6, 0xb}, 
	{0x7, 0xfe}, 
	{0x8, 0xb}, 
	{0x20, 0x300}, 
	{0x21, 0x8400}, 
	{0x66, 0x1000}, 
	{0x67, 0x503}, 
	{0x65, 0xa000}, 
	{0x65, 0x2000}, 
	{0xf0, 0x1}, 
	{0xc6, 0xa122}, 
	{0xc8, 0x1}, 
	{0xc6, 0xa123}, 
	{0xc8, 0x0}, 
	{0xc6, 0xa124}, 
	{0xc8, 0x1}, 
	{0xc6, 0xa125}, 
	{0xc8, 0x0}, 
	{0xc6, 0xa126}, 
	{0xc8, 0x1}, 
	{0xc6, 0xa127}, 
	{0xc8, 0x0}, 
	{0xc6, 0xa128}, 
	{0xc8, 0x0}, 
	{0xc6, 0xa129}, 
	{0xc8, 0x3}, 
	{0xc6, 0xa12a}, 
	{0xc8, 0x2}, 
	{0xc6, 0xa12b}, 
	{0xc8, 0x3}, 
	{0xc6, 0xa12c}, 
	{0xc8, 0x0}, 
	{0xc6, 0xa12d}, 
	{0xc8, 0x3}, 
	{0xc6, 0xa12e}, 
	{0xc8, 0x0}, 
	{0xc6, 0xa12f}, 
	{0xc8, 0x0}, 
	{0xc6, 0xa130}, 
	{0xc8, 0x4}, 
	{0xc6, 0xa131}, 
	{0xc8, 0x0}, 
	{0xc6, 0xa132}, 
	{0xc8, 0x1}, 
	{0xc6, 0xa133}, 
	{0xc8, 0x0}, 
	{0xc6, 0xa134}, 
	{0xc8, 0x1}, 
	{0xc6, 0xa135}, 
	{0xc8, 0x0}, 
	{0xc6, 0xa136}, 
	{0xc8, 0x0}, 
	{0xc6, 0xa137}, 
	{0xc8, 0x0}, 
	{0xc6, 0xa138}, 
	{0xc8, 0x0}, 
	{0xc6, 0xa139}, 
	{0xc8, 0x0}, 
	{0xc6, 0xa13a}, 
	{0xc8, 0x0}, 
	{0xc6, 0xa13b}, 
	{0xc8, 0x0}, 
	{0xc6, 0xa13c}, 
	{0xc8, 0x0}, 
	{0xc6, 0xa13d}, 
	{0xc8, 0x0}, 
	{0xc6, 0x2703}, 
	{0xc8, 0x140}, 
	{0xc6, 0x2705}, 
	{0xc8, 0xf0}, 
	{0xc6, 0x2707}, 
	{0xc8, 0x140}, 
	{0xc6, 0x2709}, 
	{0xc8, 0xf0}, 
	{0xc6, 0x270b}, 
	{0xc8, 0x30}, 
	{0xc6, 0x270f}, 
	{0xc8, 0x1c}, 
	{0xc6, 0x2711}, 
	{0xc8, 0x3c}, 
	{0xc6, 0x2713}, 
	{0xc8, 0x4b0}, 
	{0xc6, 0x2715}, 
	{0xc8, 0x640}, 
	{0xc6, 0x2717}, 
	{0xc8, 0x0}, 
	{0xc6, 0x2719}, 
	{0xc8, 0x11}, 
	{0xc6, 0x271b}, 
	{0xc8, 0x1c}, 
	{0xc6, 0x271d}, 
	{0xc8, 0x3c}, 
	{0xc6, 0x271f}, 
	{0xc8, 0x4b0}, 
	{0xc6, 0x2721}, 
	{0xc8, 0x640}, 
	{0xc6, 0x2723}, 
	{0xc8, 0x53c}, 
	{0xc6, 0x2725}, 
	{0xc8, 0x11}, 
	{0xc6, 0x2727}, 
	{0xc8, 0x0}, 
	{0xc6, 0x2729}, 
	{0xc8, 0x320}, 
	{0xc6, 0x272b}, 
	{0xc8, 0x0}, 
	{0xc6, 0x272d}, 
	{0xc8, 0x258}, 
	{0xc6, 0x2735}, 
	{0xc8, 0x0}, 
	{0xc6, 0x2737}, 
	{0xc8, 0x640}, 
	{0xc6, 0x2739}, 
	{0xc8, 0x0}, 
	{0xc6, 0x273b}, 
	{0xc8, 0x4b0}, 
	{0xc6, 0xa743}, 
	{0xc8, 0x42}, 
	{0xc6, 0xa744}, 
	{0xc8, 0x42}, 
	{0xc6, 0xa745}, 
	{0xc8, 0x0}, 
	{0xc6, 0xa746}, 
	{0xc8, 0x14}, 
	{0xc6, 0xa747}, 
	{0xc8, 0x23}, 
	{0xc6, 0xa748}, 
	{0xc8, 0x3a}, 
	{0xc6, 0xa749}, 
	{0xc8, 0x5e}, 
	{0xc6, 0xa74a}, 
	{0xc8, 0x76}, 
	{0xc6, 0xa74b}, 
	{0xc8, 0x88}, 
	{0xc6, 0xa74c}, 
	{0xc8, 0x96}, 
	{0xc6, 0xa74d}, 
	{0xc8, 0xa3}, 
	{0xc6, 0xa74e}, 
	{0xc8, 0xaf}, 
	{0xc6, 0xa74f}, 
	{0xc8, 0xba}, 
	{0xc6, 0xa750}, 
	{0xc8, 0xc4}, 
	{0xc6, 0xa751}, 
	{0xc8, 0xce}, 
	{0xc6, 0xa752}, 
	{0xc8, 0xd7}, 
	{0xc6, 0xa753}, 
	{0xc8, 0xe0}, 
	{0xc6, 0xa754}, 
	{0xc8, 0xe8}, 
	{0xc6, 0xa755}, 
	{0xc8, 0xf0}, 
	{0xc6, 0xa756}, 
	{0xc8, 0xf8}, 
	{0xc6, 0xa757}, 
	{0xc8, 0xff}, 
	{0xc6, 0xa758}, 
	{0xc8, 0x0}, 
	{0xc6, 0xa759}, 
	{0xc8, 0x14}, 
	{0xc6, 0xa75a}, 
	{0xc8, 0x23}, 
	{0xc6, 0xa75b}, 
	{0xc8, 0x3a}, 
	{0xc6, 0xa75c}, 
	{0xc8, 0x5e}, 
	{0xc6, 0xa75d}, 
	{0xc8, 0x76}, 
	{0xc6, 0xa75e}, 
	{0xc8, 0x88}, 
	{0xc6, 0xa75f}, 
	{0xc8, 0x96}, 
	{0xc6, 0xa760}, 
	{0xc8, 0xa3}, 
	{0xc6, 0xa761}, 
	{0xc8, 0xaf}, 
	{0xc6, 0xa762}, 
	{0xc8, 0xba}, 
	{0xc6, 0xa763}, 
	{0xc8, 0xc4}, 
	{0xc6, 0xa764}, 
	{0xc8, 0xce}, 
	{0xc6, 0xa765}, 
	{0xc8, 0xd7}, 
	{0xc6, 0xa766}, 
	{0xc8, 0xe0}, 
	{0xc6, 0xa767}, 
	{0xc8, 0xe8}, 
	{0xc6, 0xa768}, 
	{0xc8, 0xf0}, 
	{0xc6, 0xa769}, 
	{0xc8, 0xf8}, 
	{0xc6, 0xa76a}, 
	{0xc8, 0xff}, 
	{0xc6, 0x276d}, 
	{0xc8, 0xe0e2}, 
	{0xc6, 0xa76f}, 
	{0xc8, 0xe1}, 
	{0xc6, 0x2774}, 
	{0xc8, 0xe0e1}, 
	{0xc6, 0xa776}, 
	{0xc8, 0xe1}, 
	{0xc6, 0x220b}, 
	{0xc8, 0x192}, 
	{0xc6, 0xa217}, 
	{0xc8, 0x8}, 
	{0xc6, 0x2228}, 
	{0xc8, 0x20f}, 
	{0xc6, 0x222f}, 
	{0xc8, 0x0}, 
	{0xc6, 0xa408}, 
	{0xc8, 0xff}, 
	{0xc6, 0xa409}, 
	{0xc8, 0x1}, 
	{0xc6, 0xa40a}, 
	{0xc8, 0xff}, 
	{0xc6, 0xa40b}, 
	{0xc8, 0x1}, 
	{0xc6, 0x2411}, 
	{0xc8, 0x0}, 
	{0xc6, 0x2413}, 
	{0xc8, 0x0}, 
	{0xf0, 0x1}, 
	{0xc6, 0xa103}, 
	{0xc8, 0x6}, 
	{0xf0, 0x1}, 
	{0xc6, 0xa103}, 
	{0xc8, 0x5}, 
	{0xf0, 0x1}, 
	{0x97, 0x20}, 
	{0xff, 0xffff},	
};

                                                                            
const struct sensor_reg MT9D111_QVGA_3fps[] PROGMEM=
{    
		{0xf0, 0x0}, 
		
		
		//{0x65, 0xA000},
		//{0x65, 0x2000},
		
		{0x33, 0x343}, 
		{0xf0, 0x1}, 
		{0xc6, 0xa115}, 
		{0xc8, 0x20}, 
		{0xf0, 0x0}, 
		{0x38, 0x866}, 
		{0xf0, 0x1}, 
		{0xc6, 0x2703}, 
		{0xc8, 0x640}, 
		{0xc6, 0x2705}, 
		{0xc8, 0x4b0}, 
		{0xf0, 0x0}, 
		{0x21, 0x402}, //Mirror Column
		{0xf0, 0x1}, 
		{0xc6, 0x2729}, 
		{0xc8, 0x640}, 
		{0xc6, 0x272d}, 
		{0xc8, 0x4b0}, 
		{0xc6, 0xa103}, 
		{0xc8, 0x5}, 
		{0xf0, 0x0}, 
		{0xf2, 0x0}, 
		{0x3, 0x4b0}, 
		{0x4, 0x640}, 
		{0x65, 0xe000}, 
		{0x66, 0x1902}, 
		{0x67, 0x500}, 
		{0x65, 0xa000}, 
		{0xf0, 0x1}, 
		{0x97, 0x20}, 
		{0x98, 0x0}, 
		{0xf0, 0x1}, 
		{0x97, 0x20}, 
		{0xf0, 0x0}, 
		{0x33, 0x343}, 
		{0xf0, 0x1}, 
		{0xc6, 0xa115}, 
		{0xc8, 0x20}, 
		{0xf0, 0x0}, 
		{0x38, 0x866}, 
		{0xf0, 0x1}, 
		{0xc6, 0x2703}, 
		{0xc8, 0x640}, 
		{0xc6, 0x2705}, 
		{0xc8, 0x4b0}, 
		{0xf0, 0x0}, 
		{0x21, 0x402}, 
		{0x20, 0x7b6}, 
		{0xf0, 0x1}, 
		{0xc6, 0x2729}, 
		{0xc8, 0x640}, 
		{0xc6, 0x272d}, 
		{0xc8, 0x4b0}, 
		{0xc6, 0xa103}, 
		{0xc8, 0x5}, 
		{0xf0, 0x0}, 
		/*
		{0x05, 0x00A2},
		{0x06, 0x0022},
		{0x07, 0x00A2},
		{0x08, 0x000B},
		{0x20, 0x07B4},
		{0x21, 0x04B4},
		{0x66, 0x5008},
		{0x67, 0x506 },
		*/
		{0xf2, 0x0}, 
		{0x3, 0x4b0}, 
		{0x4, 0x640}, 
		{0x65, 0xe000}, 
		{0x66, 0x1902}, 
		{0x67, 0x500}, 
		{0x65, 0xa000}, 
		{0xf0, 0x1}, 
		{0x97, 0x20}, 
		{0x98, 0x0}, 
		{0xf0, 0x1}, 
		{0xc6, 0x2703}, 
		{0xc8, 0x140}, 
		{0xc6, 0x2705}, 
		{0xc8, 0xf0}, 
		{0xc6, 0x2707}, 
		{0xc8, 0x140}, 
		{0xc6, 0x2709}, 
		{0xc8, 0xf0}, 
		{0xc6, 0x2779}, 
		{0xc8, 0x140}, 
		{0xc6, 0x277b}, 
		{0xc8, 0xf0}, 
		{0xc6, 0xa103}, 
		{0xc8, 0x5}, 
		/*
		{0xc6, 0x2120}, 
		{0xc8, 0x0},
		
		{0xc6, 0x2103}, 
		{0xc8, 0x1},
		*/
		{0xff, 0xffff},
};


#endif //MT9D111_REGS_H